module.exports = [
  {
    title: "Rubber Recycled Permeable Pavements (RRPPs)",
    url: "https://staplab.uwindsor.ca/research/rrpps",
    image: "https://res.cloudinary.com/doqvfemo3/image/upload/f_auto,q_auto/v1/Staplab/oktzmszb3wtwtluzi8tb",
    category: "Sustainable Pavement Materials",
    content: "This research focuses on the use of Reclaimed Asphalt Pavement (RAP) and Recycled Concrete Aggregates (RCA) in asphalt mixtures to promote sustainability in transportation infrastructure. The study aims to maximize the replacement of natural aggregates—up to 100%—while maintaining or improving pavement performance.\n\nThe research evaluates the physical properties of RAP and RCA, applies rejuvenation techniques such as waste frying oil and crumb rubber, and optimizes asphalt mix designs using Superpave and Marshall methods. Key performance tests include Marshall Stability, Indirect Tensile Strength, Resilient Modulus, and Wheel Tracking.\n\nEnvironmental and economic impacts are assessed through life cycle analysis, supporting circular economy principles and reducing reliance on virgin materials. This work seeks to inform standards for fully recycled asphalt and contribute to sustainable pavement practices.",
    author: "Kazeem Akanbi",
  },
  {
    title: "Recycling Volumes Analysis",
    url: "https://staplab.uwindsor.ca/research/recycling-volumes",
    image: "https://res.cloudinary.com/doqvfemo3/image/upload/f_auto,q_auto/v1/Staplab/oktzmszb3wtwtluzi8tb",
    category: "Sustainable Pavement Materials",
    content: "This research investigates the quality and performance of recycled concrete aggregates (RCA) to support waste reduction and reuse in concrete production. The study explores mechanical treatments—using the Micro Deval test and a concrete mixer—and chemical treatments, particularly acetic acid, to enhance RCA properties.\n\nTreated aggregates are incorporated into concrete mixtures using the Equivalent Mortar Volume Method and the Absolute Volume Method. Findings demonstrate that these treatments significantly improve RCA performance, making it a viable substitute for natural aggregates.\n\nThis work advances circularity in construction materials and highlights the potential for renewable resources in concrete production. Part of this research has been published in Transportation Research Record (DOI: 10.1177/03611981251328988).",
    author: "Petra Monaco, Rita Petros, Ayah Shinneeb",
  },
  {
    title: "Eco-Friendly Material Integration",
    url: "https://staplab.uwindsor.ca/research/eco-materials",
    image: "https://res.cloudinary.com/doqvfemo3/image/upload/f_auto,q_auto/v1/Staplab/oktzmszb3wtwtluzi8tb",
    category: "Sustainable Pavement Materials",
    content: "This project explores Lightweight Cellular Concrete (LCC), a foam-based material with reduced cement content, for sustainable construction. The research evaluates its mechanical properties—such as strength and density—and examines environmental benefits, including improved insulation and lower emissions.\n\nAdditionally, the study incorporates Probabilistic Life Cycle Assessment (LCA) using Monte Carlo simulations to quantify uncertainties in environmental impacts like CO₂ emissions and energy use. This approach supports data-driven decisions for low-carbon infrastructure.\n\nThe project aims to optimize material performance and promote sustainability in pavement and building applications, contributing to eco-friendly construction practices.",
    author: "Joy Uchenna, Yasmeen Al-Jeboury",
  },
  {
    title: "Finite Element Modeling (FEM) for Pavements",
    url: "https://staplab.uwindsor.ca/research/fem-pavements",
    image: "https://res.cloudinary.com/doqvfemo3/image/upload/f_auto,q_auto/v1/Staplab/oktzmszb3wtwtluzi8tb",
    category: "Modern Pavement Design",
    content: "This project focuses on the application of Finite Element Modeling (FEM) to analyze pavement structures and improve design efficiency. The research develops computational models to simulate pavement behavior under various loading and environmental conditions.\n\nBy integrating material properties and performance data, the study aims to enhance pavement durability and reduce maintenance costs. The findings support the development of advanced design methodologies for sustainable and resilient infrastructure.",
    author: "Morteza Karbasi",
  },
  {
    title: "Machine Learning in Pavement Design",
    url: "https://staplab.uwindsor.ca/research/ml-pavements",
    image: "https://res.cloudinary.com/doqvfemo3/image/upload/f_auto,q_auto/v1/Staplab/oktzmszb3wtwtluzi8tb",
    category: "Modern Pavement Design",
    content: "This research explores the use of machine learning techniques to optimize pavement design and predict performance. By analyzing large datasets on material properties, traffic loads, and environmental factors, the study develops predictive models to improve design accuracy.\n\nThe project aims to enhance decision-making in pavement engineering, reducing costs and extending service life. The outcomes contribute to modern, data-driven approaches in infrastructure design.",
    author: "Morteza Karbasi",
  },
  {
    title: "PMED Calibration Studies",
    url: "https://staplab.uwindsor.ca/research/pmed-calibration",
    image: "https://res.cloudinary.com/doqvfemo3/image/upload/f_auto,q_auto/v1/Staplab/oktzmszb3wtwtluzi8tb",
    category: "Modern Pavement Design",
    content: "This project focuses on calibrating the Pavement Mechanistic-Empirical Design (PMED) framework to improve its accuracy for local conditions. The research involves field data collection and laboratory testing to refine model inputs and validate predictions.\n\nBy enhancing PMED’s reliability, the study supports the design of durable and cost-effective pavements. The results inform transportation agencies and contribute to advanced pavement engineering practices.",
    author: "Ochuko Keren Eyeta",
  },
  {
    title: "Climate Impact Assessments",
    url: "https://staplab.uwindsor.ca/research/climate-impacts",
    image: "https://res.cloudinary.com/doqvfemo3/image/upload/f_auto,q_auto/v1/Staplab/oktzmszb3wtwtluzi8tb",
    category: "Transportation Infrastructure",
    content: "This research conducts Probabilistic Life Cycle Assessment (LCA) of sustainable pavements, developing a framework that integrates uncertainty analysis to evaluate environmental impacts. The study begins with a deterministic LCA model, then applies probability distributions to key variables—such as material inputs—and conducts Monte Carlo simulations.\n\nReal-world case studies validate the framework, producing a probabilistic LCA tool that enhances transparency and supports sustainable decision-making in pavement design, material selection, and infrastructure policy.",
    author: "Ochuko Keren Eyeta, Joy Uchenna",
  },
  {
    title: "Lifecycle Cost Analysis (LCCA)",
    url: "https://staplab.uwindsor.ca/research/lcca",
    image: "https://res.cloudinary.com/doqvfemo3/image/upload/f_auto,q_auto/v1/Staplab/oktzmszb3wtwtluzi8tb",
    category: "Transportation Infrastructure",
    content: "This project performs Lifecycle Cost Analysis to evaluate the economic viability of sustainable pavement materials and designs. The research integrates costs of construction, maintenance, and disposal, considering environmental factors like emissions and resource use.\n\nBy comparing traditional and recycled materials, the study supports cost-effective and eco-friendly infrastructure decisions. The findings guide policymakers and engineers in optimizing transportation systems.",
    author: "Kazeem Akanbi",
  },
  {
    title: "Accessibility and Resilience Frameworks",
    url: "https://staplab.uwindsor.ca/research/accessibility-frameworks",
    image: "https://res.cloudinary.com/doqvfemo3/image/upload/f_auto,q_auto/v1/Staplab/oktzmszb3wtwtluzi8tb",
    category: "Transportation Infrastructure",
    content: "This research investigates how road infrastructure conditions impact accessibility in urban communities, exploring user and policymaker perceptions to understand pavement maintenance decisions. The study also develops frameworks to enhance transportation resilience.\n\nAdditionally, it examines Lightweight Cellular Concrete (LCC) as a sustainable pavement base material, optimizing its strength and insulation properties. The project contributes to inclusive, equitable, and sustainable transportation systems.",
    author: "Yasmeen Al-Jeboury",
  },
  {
    title: "Field Evaluation of Sustainable Pavements",
    url: "https://staplab.uwindsor.ca/research/field-evaluations",
    image: "https://res.cloudinary.com/doqvfemo3/image/upload/f_auto,q_auto/v1/Staplab/oktzmszb3wtwtluzi8tb",
    category: "All",
    content: "This project conducts field evaluations of sustainable pavements, focusing on Probabilistic Life Cycle Assessment (LCA) to quantify environmental impacts. Using Monte Carlo simulations, the research assesses uncertainties in CO₂ emissions and energy use, supporting low-carbon infrastructure.\n\nThe study tests real-world case studies to validate findings, aiming to develop a transparent LCA tool that informs sustainable pavement design and policy decisions.",
    author: "Ochuko Keren Eyeta, Joy Uchenna",
  },
  {
    title: "Proposed Low-Impact Pavement Designs",
    url: "https://staplab.uwindsor.ca/research/proposed-designs",
    image: "https://res.cloudinary.com/doqvfemo3/image/upload/f_auto,q_auto/v1/Staplab/oktzmszb3wtwtluzi8tb",
    category: "All",
    content: "This research focuses on Sustainable Low Impact Development (SLID) in pavement design, evaluating the environmental and health impacts of surfacing materials. A field-based analysis compares Poured-in-Place (PIP) rubber, synthetic turf, and engineered wood fiber (EWF) using VOC sensors and temperature monitoring.\n\nThe study aims to develop SLID guidelines for urban pavements, informing municipal policy and promoting sustainable, health-conscious infrastructure.",
    author: "Masoumeh Mazandarani",
  },
  {
    title: "Smart Sensing for Infrastructure",
    url: "https://staplab.uwindsor.ca/research/smart-sensing",
    image: "https://res.cloudinary.com/doqvfemo3/image/upload/f_auto,q_auto/v1/Staplab/oktzmszb3wtwtluzi8tb",
    category: "All",
    content: "This research integrates smart materials into asphalt mixtures to enhance pavement performance and enable early failure detection. The study evaluates conductive and responsive additives through tests like rutting resistance, fatigue testing, and microstructural analysis.\n\nAdditionally, it develops self-sensing asphalt for real-time strain and stress monitoring, improving durability and maintenance efficiency.\n\nThe project aims to create intelligent, self-monitoring pavements, supporting sustainable and resilient transportation infrastructure.",
    author: "Morteza Karbazi Rita Petros, Nicole Stojakovic, Ayah Shinneeb",
  },
];